import { Document, DocumentType, ApiResponse } from '../types';

const API_BASE_URL = 'https://api.virgo-sy.com';

export async function fetchNextDocument(): Promise<ApiResponse<Document>> {
  try {
    const response = await fetch(`${API_BASE_URL}/document/next`, {
      credentials: 'include',
      headers: {
        'Accept': 'application/json',
      }
    });
    
    if (!response.ok) {
      throw new Error('API request failed');
    }
    
    const data = await response.json();
    return { data };
  } catch (error) {
    return { data: null, error: 'Failed to fetch document' };
  }
}

export async function updateDocumentType(documentId: string, typeId: string): Promise<ApiResponse<void>> {
  try {
    const response = await fetch(`${API_BASE_URL}/document/update`, {
      method: 'POST',
      credentials: 'include',
      headers: {
        'Content-Type': 'application/json',
        'Accept': 'application/json',
      },
      body: JSON.stringify({ document_id: documentId, documenttype_id: typeId }),
    });

    if (!response.ok) {
      throw new Error('API request failed');
    }

    return { data: null };
  } catch (error) {
    return { data: null, error: 'Failed to update document type' };
  }
}